/*=====================================================
*  mHand 3.5                                          *
*                                                     *
*  PowerBuilder Expand Function Dynamic Link Library  *
*  Created : 1996.01.16   Last Modified : 1999.08.03  *
*                                                     *
*                  - Jianhui.Wang  ( TianJin CHINA )  
*
=====================================================*/

#include <windows.h>

#ifdef _DEBUG
class CDebug
{
private:
	static void ReportValue(LPSTR);
public:
	static void WatchValue(LPSTR);
	static void WatchValue(WORD);
};
#endif

extern "C"

BOOL APIENTRY DllMain(HANDLE hModule,DWORD ul_reason_for_call,LPVOID lpReserved)
{
    return TRUE;
}

int WINAPI SetPaperSize(WORD nWidth,WORD nHeight,WORD nOrient)
{
	#define ExpectA3 ((nWidth==2970)&&(nHeight==4200))
	#define ExpectA4 ((nWidth==2100)&&(nHeight==2970))
	#define ExpectB5 ((nWidth==1820)&&(nHeight==2570))
	
	HKEY hRegKey;
	char szPrinterKey[100]="System\\CurrentControlSet\\Control\\Print\\Printers\\";
	char szDeviceName[40],szPort[40];
	DWORD cbBuffer;
	DWORD dwRV;
	DWORD dwPapers;
	WORD lpwPapers[256];
	BOOL fSupportUserDefind=FALSE,fSupportA3=FALSE,fSupportA4=FALSE,fSupportB5=FALSE;
	HANDLE hDriver;
	HGLOBAL hMem;
	LPDEVMODE lpDevMode;

	//ȡǰĬϴӡ豸
	RegOpenKey(HKEY_CURRENT_CONFIG,"System\\CurrentControlSet\\Control\\Print\\Printers",&hRegKey);
	cbBuffer=sizeof(szDeviceName);
	dwRV=RegQueryValueEx(hRegKey,"Default",NULL,NULL,(unsigned char *)szDeviceName,&cbBuffer);
	RegCloseKey(hRegKey);
	if (dwRV != ERROR_SUCCESS) return -1;
	
	//ȡӡ˿
	RegOpenKey(HKEY_LOCAL_MACHINE,lstrcat(szPrinterKey,szDeviceName),&hRegKey);
	cbBuffer=sizeof(szPort);
	dwRV=RegQueryValueEx(hRegKey,"Port",NULL,NULL,(unsigned char *)szPort,&cbBuffer);
	RegCloseKey(hRegKey);
	if (dwRV != ERROR_SUCCESS) return -2;

	//ȡӡֵ֧ȫֽ
	dwPapers=DeviceCapabilitiesA(szDeviceName,szPort,DC_PAPERS,(LPTSTR)lpwPapers,NULL);
	if ((dwPapers < 1) || (dwPapers > 256)) return -3;

	//жϴӡǷ֧Զ塢A3A4B5ֽ
	do
		switch (lpwPapers[--dwPapers])
		{
			case DMPAPER_USER:
				fSupportUserDefind=TRUE;
				break;
			case DMPAPER_A3:
				fSupportA3=TRUE;
				break;
			case DMPAPER_A4:
				fSupportA4=TRUE;
				break;
			case DMPAPER_B5:
				fSupportB5=TRUE;
				break;
		}
	while (dwPapers > 0);

	//ȡӡDeviceMode
	if (! OpenPrinter(szDeviceName,(LPHANDLE)&hDriver,NULL)) return -4;
	hMem=GlobalAlloc(GPTR,DocumentProperties(NULL,hDriver,szDeviceName,NULL,NULL,0));
	lpDevMode=(LPDEVMODE)GlobalLock(hMem);
	DocumentProperties(NULL,hDriver,szDeviceName,lpDevMode,NULL,DM_OUT_BUFFER);

	//ֽͻС
	switch ((ExpectA3 && fSupportA3)*1 + (ExpectA4 && fSupportA4)*2 + (ExpectB5 && fSupportB5)*3)
	{
		case 1: //A3
			lpDevMode->dmFields=DM_PAPERSIZE;
			lpDevMode->dmPaperSize=DMPAPER_A3;
		case 2: //A4
			lpDevMode->dmFields=DM_PAPERSIZE;
			lpDevMode->dmPaperSize=DMPAPER_A4;
			break;
		case 3: //B5
			lpDevMode->dmFields=DM_PAPERSIZE;
			lpDevMode->dmPaperSize=DMPAPER_B5;
			break;
		default:
			if (fSupportUserDefind)
			{
				lpDevMode->dmFields=DM_PAPERSIZE|DM_PAPERWIDTH|DM_PAPERLENGTH;
				lpDevMode->dmPaperSize=DMPAPER_USER;
				lpDevMode->dmPaperWidth=nWidth;
				lpDevMode->dmPaperLength=nHeight;
			}
			else
				lpDevMode->dmFields=0;
			break;
	}

	//÷
	switch (nOrient)
	{
		case 0:
			lpDevMode->dmFields|=DM_ORIENTATION;
			lpDevMode->dmOrientation=DMORIENT_PORTRAIT;
			break;
		case 1:
			lpDevMode->dmFields|=DM_ORIENTATION;
			lpDevMode->dmOrientation=DMORIENT_LANDSCAPE;
			break;
	}

	DocumentProperties(NULL,hDriver,szDeviceName,NULL,lpDevMode,DM_IN_BUFFER|DM_UPDATE);

	GlobalUnlock(hMem);
	GlobalFree(hMem);
	ClosePrinter(hDriver);
	
	return 1;
}

BOOL WINAPI GetFileDateTime(LPCSTR lpFileName,WORD nMode,LPTSTR lpDate,LPTSTR lpTime)
{
	HANDLE hFile;
	FILETIME CreationTime,LastAccessTime,LastWriteTime,LocalFileTime;
	SYSTEMTIME SystemTime;

	hFile=CreateFile(lpFileName,0,0,NULL,OPEN_EXISTING,0,NULL);
	if (hFile==INVALID_HANDLE_VALUE) return FALSE;

	GetFileTime(hFile,&CreationTime,&LastAccessTime,&LastWriteTime);
	switch (nMode)
	{
		case 0:
			FileTimeToLocalFileTime(&CreationTime,&LocalFileTime);
			break;
		case 1:
			FileTimeToLocalFileTime(&LastAccessTime,&LocalFileTime);
			break;
		case 2:
			FileTimeToLocalFileTime(&LastWriteTime,&LocalFileTime);
			break;
	}
	FileTimeToSystemTime(&LocalFileTime,&SystemTime);

	wsprintf(lpDate,"%04d/%02d/%02d",SystemTime.wYear,SystemTime.wMonth,SystemTime.wDay);
	wsprintf(lpTime,"%02d:%02d:%02d",SystemTime.wHour,SystemTime.wMinute,SystemTime.wSecond);

	CloseHandle(hFile);

	return TRUE;
}

BOOL WINAPI SetSystemDateTime(WORD wYear,WORD wMonth,WORD wDay,WORD wHour,WORD wMinute,WORD wSecond)
{
	SYSTEMTIME SystemTime;
	FILETIME LocalFileTime,FileTime;

	SystemTime.wYear=wYear;
	SystemTime.wMonth=wMonth;
    SystemTime.wDay=wDay;
    SystemTime.wHour=wHour;
    SystemTime.wMinute=wMinute;
    SystemTime.wSecond=wSecond;
    SystemTime.wMilliseconds=0;

	SystemTimeToFileTime(&SystemTime,&LocalFileTime);
	LocalFileTimeToFileTime(&LocalFileTime,&FileTime);
	FileTimeToSystemTime(&FileTime,&SystemTime);

	return SetSystemTime(&SystemTime);
}

#ifdef _DEBUG
void CDebug::ReportValue(LPSTR szMsg)
{
	MessageBox(NULL,szMsg,"Watch Value",MB_ICONINFORMATION|MB_OK);
}

void CDebug::WatchValue(LPSTR lpVar)
{
	char szMessage[255];
	wsprintf(szMessage,"String Value : '%s'",lpVar);
	ReportValue(szMessage);
}
void CDebug::WatchValue(WORD wVar)
{	char szMessage[255];
	wsprintf(szMessage,"Word Value : '%d'",wVar);
	ReportValue(szMessage);
}
#endif